/*******************************************************
Filename		:  di_date_table.sql
Release 		:  c2.0
SIR			:  1470
Description		:  create and populate di_date table.
Author			:  Joseph Wilson
Date			:  1/12/2003 -- start date changed to 1-JAN-1900
			   01/16/04 - SIR 1586 Moved connect string to master install script -JW
Comments		:  Should we add something other than year to fiscal_period?
**********************************************************/

SPOOL di_date_table.log

drop table di_date;

create table di_date
(pk_isn number(12,0),
 full_date date,
 day_of_week char(9),
 day_number_in_month number(2),
 day_number_overall number(5),
 week_number_in_year number(2),
 week_number_overall number(4),
 month char(9),
 month_number_overall number(4),
 quarter number(1),
 fiscal_period number(4),
 weekday_flag char(1),
 last_day_in_month_flag char(1))
tablespace storetdata
storage (initial 5M next 5M)
nologging;

drop sequence seq_di_date;

create sequence seq_di_date
start with 1 increment by 1 nomaxvalue nocycle cache 10;

--populate di_date table
set serveroutput on
DECLARE
v_date_start date := '1-JAN-1900';
v_date_end date := '1-JAN-2051';
v_date date;
v_day_number_overall number := 1;
v_last_day char(1) := NULL;
v_weekday char(1):= NULL;
v_week_number_overall number := 1;
v_month_number_overall number := 1;
BEGIN
v_date := v_date_start;
IF v_date = LAST_DAY(v_date) THEN
	v_last_day := 'Y';
END IF;
IF TO_CHAR(v_date,'D') <> 1 AND TO_CHAR(v_date,'D') <> 7 THEN
	v_weekday := 'Y';
END IF;
INSERT INTO DI_DATE (
	pk_isn, 
	full_date, 
	day_of_week, 
	day_number_in_month, 
	day_number_overall, 
	week_number_in_year, 
	week_number_overall,
	month,
	month_number_overall,
	quarter,
	fiscal_period,
	weekday_flag,
	last_day_in_month_flag)
VALUES (
	seq_di_date.nextval,
	v_date,
	TO_CHAR(v_date,'DAY'),
	TO_CHAR(v_date,'DD'),
	v_day_number_overall,
	TO_CHAR(v_date,'WW'),
	v_week_number_overall,
	TO_CHAR(v_date,'MONTH'),
	v_month_number_overall,
	TO_CHAR(v_date,'Q'),
	TO_CHAR(v_date,'YYYY'),
	v_weekday,
	v_last_day
);

LOOP
	v_last_day := NULL;
	v_weekday := NULL;
	IF TO_CHAR(v_date,'WW')<>TO_CHAR(v_date+1,'WW') THEN
		v_week_number_overall := v_week_number_overall +1;
	END IF;
	IF TO_CHAR(v_date,'MM')<>TO_CHAR(v_date+1,'MM') THEN
		v_month_number_overall := v_month_number_overall +1;
	END IF;

	v_date := v_date + 1;
	EXIT WHEN v_date = v_date_end;
	v_day_number_overall := v_day_number_overall + 1;

	IF v_date = LAST_DAY(v_date) THEN
		v_last_day := 'Y';
	END IF;
	IF TO_CHAR(v_date,'D') <> 1 AND TO_CHAR(v_date,'D') <> 7 THEN
		v_weekday := 'Y';
	END IF;

	INSERT INTO DI_DATE (
		pk_isn, 
		full_date, 
		day_of_week, 
		day_number_in_month, 
		day_number_overall, 
		week_number_in_year, 
		week_number_overall,
		month,
		month_number_overall,
		quarter,
		fiscal_period,
		weekday_flag,
		last_day_in_month_flag)
	VALUES (
		seq_di_date.nextval,
		v_date,
		TO_CHAR(v_date,'DAY'),
		TO_CHAR(v_date,'DD'),
		v_day_number_overall,
		TO_CHAR(v_date,'WW'),
		v_week_number_overall,
		TO_CHAR(v_date,'MONTH'),
		v_month_number_overall,
		TO_CHAR(v_date,'Q'),
		TO_CHAR(v_date,'YYYY'),
		v_weekday,
		v_last_day
	);
END LOOP;
END;
/
COMMIT;

alter table di_date
modify pk_isn number not null;

alter table di_date
add constraint pk_date primary key (pk_isn)
using index
tablespace storetindx
storage(initial 3M next 3M);    

create index idate_full_date on di_date(full_date)
tablespace storetindx
storage (initial 3M next 3M)
nologging;

SPOOL OFF